# Software Engineering

## 객체지향 프로그래밍(OOP)

<details>
  <summary> 객체지향 프로그래밍이란 무엇인가요?</summary>

> 객체지향프로그램이란 일종의 코드 패러다임이라고 생각합니다. 객체지향 프로그래밍의 이전은 컴퓨터가 사고하여 코딩했지만 개발자들이 어떻게 좋은 코드를 짤까 고민하며 속성과 메소드를 사람이 인지하여 코드 작성하기 시작했고, 결과로 코드의 가독성 증가, 유지보수성 증가 등등 많은 장점들이 발생하였습니다. 즉, 객체지향 프로그래밍은 프로그램의 대한 인지론 중 하나입니다.  
</details>

<details>
  <summary> 객체지향 프로그래밍의 단점은 무엇인가요?</summary>
  
> 보통 얘기하는 용량증가나 복잡성 증가가 있지만 개인적으로 이는 상대적인 것 같습니다. 다른 것을 적용해도 똑같은 단점이 존재할 것입니다.
> 
> - 실행 속도가 느림
> - 프로그램 용량이 큼 - 객체 단위로 프로그램을 많이 만들다보면, 불필요한 정보들이 같이 삽입될 수 있고, 이는 프로그램의 용량 증가로 이어질 수 있습니다.
> - 설계에 많은 시간 소요 - 클래스별로, 객체별로 설계하고, 상속 등의 구조 또한 설계하여야 하기 때문에, 설계단계부터 많은 시간이 소모됩니다.

</details>

<details>
  <summary> 흔히 얘기하는 단점은 모두 가지고 있으니 이왕이면 장점이 더 많은 객체지향 프로그래밍을 사용하자는 말인가요?</summary>
  
> 다수가 선호하는 패러다임은 존재한다고 생각합니다. 장점이 더 많아서, 좋아서 쓴다기 보다는 다수가 사용하는 패러다임을 사용하자는 의견입니다.

</details>

<details>
  <summary> 본인 관점에서 좋지 않은 방법이 새로운 패러다임으로 자리잡을 경우, 다수가 사용하는 패러다임이기 때문에 본인 역시 사용할 것인지 궁금합니다. </summary>
  
> 현재 멀티 패러다임의 개념이 등장 했습니다. 예를들어 현재 새롭게 떠오르는 자바스크립트의 함수형 프로그래밍 패러다임과 기존의 객체지향 프로그래밍의 패러다임이 섞여서 유지되고 있습니다. 즉, 하나의 패러다임만을 쓰기 보단 여러 개를 적절히 섞어서 사용하는 것이 중요한 것 같다.
> 
> Q. 함수형 프로그래밍이란?
>> - 함수형 프로그래밍은 거의 모든 것을 순수 함수로 나누어 문제를 해결하는 기법으로, 작은 문제를 해결하기 위한 함수를 작성하여 가독성을 높이고 유지보수를 용이하게 해준다.
  
</details>

<details>
  <summary> 객체지향 프로그래밍의 특징은 무엇인가요?</summary>
  
> - 추상화 - 객체의 공통적인 속성과 기능을 추출하여 정의하는 것
> 
> - 캡슐화 - 서로 연관있는 속성과 기능들을 하나의 캡슐(capsule)로 만들어 데이터를 외부로부터 보호하는 것. 즉, 외부와 내부를 분리하여 사용하는 것.
> 
> - 상속 - 기존의 클래스를 재활용하여 새로운 클래스를 작성하는 것. 코드의 재사용성을 높여 반복적인 코드를 최소화하고 공유하는 속성과 기능에 간편하게 접근할 수 있게 해준다.
> 
> - 다형성 - 어떤 객체의 속성이나 기능이 상황에 따라 여러 가지 형태를 가질 수 있는 성질이다. 언어마다 다르지만, 자바를 기준으로 설명하자면 오버로딩이나 오버라이딩이 존재
  
</details>

<details>
  <summary> 추상화가 필요한 이유를 예를들어 설명해주세요.</summary>
  
> 추상화란 공통적인 속성이나 기능을 추출하여 하나로 정의하는 걸 의미한다. 많이 사용되는 예시를 생각해보자면, 오토바이나 자전거 모두 '이동 수단'입니다. 또한 공통적인 기능으로는 '운전'이 있습니다. 이를 하나로 묶어서 '이동 수
> 단'이라는 상위 클래스와 상속 관계를 만들 수 있습니다. '운전' 을 추상 메소드로 정의하여 '이동 수단'을 상속 받아 오토바이와, 자전거에서 '운전' 메소드를 재정의 하여 사용할 수 있습니다. 즉, 여러 이동 수단들과 공통적인 기능을
> 추상화하여 사용함으로서 역할과 구현의 분리를 통해 보다 가독성있고 일관성있는 코드를 구현할 수 있습니다.

  
</details>

<details>
  <summary> 객체지향의 설계원칙에 대해 설명해주세요.</summary>
  
> 객체지향 프로그래밍의 설계 5원칙에는 단일 책임 원칙, 개방-폐쇄 원칙, 리스 코프 치환 원칙, 인터페이스 분리 원칙, 의존 역전 원칙이 있습니다.
>
> 1. 단일 책임 원칙이란 모든 클래스는 각각 하나의 책임만을 가져야 합니다. 또한 클래스는 해당 책임을 완전히 캡슐화해야 함을 말합니다.
>
> 2. 개방-폐쇄 원칙은 확장에는 열려있고 수정에는 닫혀있는. 즉, 기존의 코드를 변경하지 않으면서(Closed), 기능을 추가할 수 있도록(Open) 설계가 되어야 한다는 원칙을 말합니다.
>
> 3. 리스 코프 치환 원칙은 자식 클래스는 언제나 자신의 부모 클래스를 대체할 수 있다는 원칙입니다. 즉, 부모 클래스가 들어갈 자리에 자식 클래스를 넣어도 계획대로 잘 작동해야 합니다.
>
> 4. 인터페이스 분리 원칙은 클라이언트의 목적과 용도에 적합한 인터페이스 만을 제공하는 것입니다.
>
> 5. 의존 역전 원칙은 고수준 모듈은 저수준 모듈의 구현에 의존해서는 안 되며, 저수준 모듈이 고수준 모듈에 의존해야 한다는 것입니다.
>  - 고수준 모듈 : 입력과 출력으로부터 먼 추상화된 모듈
>  - 저수준 모듈: 입력과 출력으로부터 가까운 구현 모듈

</details>

<details>
  <summary> 5원칙중 SRP(단일 책임 원칙)의 적용은 어떤식으로 해야하나요?</summary>
  
> 함수형 프로그래밍에 한해 말하자면, 함수를 잘게잘게 쪼개서 정말 하나의 기능만을 수행하도록 만드는 것입니다. 즉, 하나의 임무, 책임만을 담당하도록 작게 쪼개어 설계해야한다고 생각합니다.
  
</details>

<details>
  <summary> 객체지향 프로그래밍의 설계 5원칙중 가장 중요한 원칙은 무엇이라고 생각하나요?</summary>
  
> 원칙이기 때문에 중요도는 따질 수 없을 것 같습니다. 하지만 가장 지키기 어려운건 개방-폐쇄 원칙이라고 생각합니다. </br>
> 개방-패쇄 원칙은 주니어 단계에선 인지하고 지키기가 어렵고, 어떻게 적용해야하는지는 배우고 싶습니다.

</details>

<details>
  <summary> 오버로딩과 오버라이딩의 차이점에 대해 설명해주세요.</summary>
  
> 오버라이딩은 부모 클래스와 자식 클래스 사이에서 발생하는 것으로 부모 클래스의 메소드를 자식 클래스에서 재정의하여 사용하는 것입니다. 부모 클래스의 메소드와 이름, 매개변수, 변환 타입이 모두 동일해야합니다.</br>
> 오버로딩은 동일한 클래스 내에서 같은 이름을 가진 메소드가 존재했을 때 매개변수의 개수 또는 타입을 달리하여 동일한 이름의 메소드를 정의하는 것을 의미합니다.

</details>

<details>
  <summary> 객체와 클래스와 인스턴스의 차이점에 대해 설명해주세요</summary>
  
> - 클래스: 객체를 만들어 내기 위한 틀, 연관되어 있는 변수와 메서드의 집합
> - 객체: 소프트웨어 세계에서 구현할 대상
> - 인스턴스: 소프트웨어 세계에서 구현된 실체. 각 인스턴스는 힙 영역에서 별도 생성된다.

</details>

<details>
  <summary> 함수형 프로그래밍 VS 객체지향 프로그래밍</summary>
  
>함수형 프로그래밍에서는 함수 자체가 일급 객체가 되지만, 객체지향 프로그래밍에서는 클래스가 일급 객체가 됩니다. 일급 객체란 함수의 인자로도 넘겨질 수 있고, 변수에 대입도 가능한 객체를 말합니다. 또한 함수형 프로그래밍에서는 프로그램을 상태 값을 지니지 않은 함수들의 연속으로 볼 수 있고, 객제지향 프로그래밍에서는 프로그램을 상호작용하는 객체들의 집합으로 볼 수 있습니다. 왜냐하면 함수형 프로그래밍의 경우 값의 연산 및 결과 도출 중심으로 코드작성이 이루어지고, 객체지향 프로그램의 경우 클래스 디자인과 객체들의 관계를 중심으로 코드 작성이 이루어지기 때문입니다.

</details>

<details>
  <summary> 캡슐화와 추상화의 차이에 대해 설명해주새요</summary>
  
> 캡슐화는 객체의 내부 구현을 외부로부터 숨기고, 오로지 메서드를 통해서만 상호작용하도록 함으로써 외부로부터 보호하는 것이며, 추상화는 객체의 공통된 특징과 동작을 추출하여 클래스로 정의하는 것입니다. 두 개념 모두 객체 지향 프로그래밍에서 코드의 유지보수성과 재사용성을 높이는 데에 도움을 준다는 공통점을 갖고 유사한 특성으로 볼 수 있으나 그 초점에 차이가 있습니다.
</details>


